VERSION 5.00
Begin VB.Form TK3PicTutor 
   Caption         =   "TK3 PIC Tutorial & PICtutor"
   ClientHeight    =   4380
   ClientLeft      =   60
   ClientTop       =   345
   ClientWidth     =   7560
   Icon            =   "TK3PicTutor.frx":0000
   LinkTopic       =   "Form1"
   MaxButton       =   0   'False
   MinButton       =   0   'False
   ScaleHeight     =   4380
   ScaleWidth      =   7560
   StartUpPosition =   2  'CenterScreen
   Begin VB.TextBox Text4 
      BackColor       =   &H8000000F&
      BorderStyle     =   0  'None
      Height          =   285
      Left            =   1560
      TabIndex        =   27
      Text            =   "None Yet"
      Top             =   3340
      Width           =   2415
   End
   Begin VB.TextBox Text3 
      BackColor       =   &H8000000F&
      BorderStyle     =   0  'None
      Height          =   285
      Left            =   1560
      TabIndex        =   26
      Text            =   "None Yet"
      Top             =   3100
      Width           =   2175
   End
   Begin VB.CommandButton ViewASMPSF 
      BackColor       =   &H00FFFF00&
      Caption         =   "View PSF"
      Height          =   495
      Left            =   3120
      Style           =   1  'Graphical
      TabIndex        =   21
      Top             =   2520
      Width           =   855
   End
   Begin VB.CommandButton ViewPSFASM 
      BackColor       =   &H00FFFF00&
      Caption         =   "View ASM"
      Height          =   495
      Left            =   3120
      Style           =   1  'Graphical
      TabIndex        =   20
      Top             =   600
      Width           =   855
   End
   Begin VB.CommandButton ViewOrigASM 
      BackColor       =   &H0000FFFF&
      Caption         =   "View ASM"
      Height          =   495
      Left            =   1200
      Style           =   1  'Graphical
      TabIndex        =   19
      Top             =   2520
      Width           =   855
   End
   Begin VB.CommandButton DirASM 
      BackColor       =   &H0080FF80&
      Caption         =   "DIR ASM"
      Height          =   495
      Left            =   240
      Style           =   1  'Graphical
      TabIndex        =   18
      Top             =   2520
      Width           =   855
   End
   Begin VB.CommandButton ChangePath 
      BackColor       =   &H0080FF80&
      Caption         =   "PICtutor Path "
      Height          =   495
      Left            =   4440
      Style           =   1  'Graphical
      TabIndex        =   17
      Top             =   1520
      Width           =   855
   End
   Begin VB.CommandButton Errors 
      BackColor       =   &H00FFFF00&
      Caption         =   " View Errors"
      Height          =   375
      Left            =   1680
      Style           =   1  'Graphical
      TabIndex        =   16
      Top             =   3720
      Width           =   975
   End
   Begin VB.TextBox Text2 
      BackColor       =   &H8000000F&
      BorderStyle     =   0  'None
      Height          =   285
      Left            =   1560
      TabIndex        =   14
      Text            =   "None Yet"
      Top             =   1440
      Width           =   2175
   End
   Begin VB.CommandButton ExtraNotes 
      BackColor       =   &H00FFFF00&
      Caption         =   "Notes"
      Height          =   495
      Left            =   6360
      Style           =   1  'Graphical
      TabIndex        =   13
      Top             =   1520
      Width           =   855
   End
   Begin VB.CommandButton ASMtoPSF 
      BackColor       =   &H0080FF80&
      Caption         =   "Convert"
      Height          =   495
      Left            =   2160
      Style           =   1  'Graphical
      TabIndex        =   11
      Top             =   2520
      Width           =   855
   End
   Begin VB.CommandButton PSFtoASM 
      BackColor       =   &H0080FF80&
      Caption         =   " Convert"
      Height          =   495
      Left            =   2160
      Style           =   1  'Graphical
      TabIndex        =   10
      Top             =   600
      Width           =   855
   End
   Begin VB.CommandButton ViewOrigPSF 
      BackColor       =   &H0000FFFF&
      Caption         =   "View PSF"
      Height          =   495
      Left            =   1200
      Style           =   1  'Graphical
      TabIndex        =   8
      Top             =   600
      Width           =   855
   End
   Begin VB.TextBox Text1 
      BackColor       =   &H8000000F&
      BorderStyle     =   0  'None
      Height          =   285
      Left            =   1560
      Locked          =   -1  'True
      TabIndex        =   6
      Text            =   "None Yet"
      Top             =   1200
      Width           =   2175
   End
   Begin VB.CommandButton DirPSF 
      BackColor       =   &H0080FF80&
      Caption         =   " DIR PSF"
      Height          =   495
      Left            =   240
      Style           =   1  'Graphical
      TabIndex        =   3
      Top             =   600
      Width           =   855
   End
   Begin VB.CommandButton PICtutor 
      BackColor       =   &H0000FFFF&
      Caption         =   "PICtutor"
      Height          =   855
      Left            =   5400
      Picture         =   "TK3PicTutor.frx":030A
      Style           =   1  'Graphical
      TabIndex        =   2
      Top             =   1280
      Width           =   855
   End
   Begin VB.CommandButton Quit 
      BackColor       =   &H0080FF80&
      Caption         =   "QUIT"
      Height          =   615
      Left            =   6840
      Style           =   1  'Graphical
      TabIndex        =   1
      Top             =   3120
      Width           =   615
   End
   Begin VB.CommandButton PICTuttext 
      BackColor       =   &H00FFFF00&
      Caption         =   "View Text"
      Height          =   465
      Left            =   4800
      Style           =   1  'Graphical
      TabIndex        =   0
      Top             =   3000
      Width           =   1215
   End
   Begin VB.Label Label12 
      Alignment       =   2  'Center
      Caption         =   "See Notes for info on PICtutor V2"
      ForeColor       =   &H00800000&
      Height          =   190
      Left            =   4440
      TabIndex        =   29
      Top             =   2120
      Width           =   2775
   End
   Begin VB.Label Label11 
      Alignment       =   2  'Center
      Caption         =   " EPE PIC TUTORIAL"
      BeginProperty Font 
         Name            =   "MS Sans Serif"
         Size            =   9.75
         Charset         =   0
         Weight          =   700
         Underline       =   0   'False
         Italic          =   0   'False
         Strikethrough   =   0   'False
      EndProperty
      ForeColor       =   &H00800000&
      Height          =   255
      Left            =   4320
      TabIndex        =   28
      Top             =   2640
      Width           =   2175
   End
   Begin VB.Shape Shape3 
      BorderColor     =   &H00C00000&
      BorderWidth     =   2
      Height          =   2295
      Left            =   4200
      Shape           =   4  'Rounded Rectangle
      Top             =   120
      Width           =   3255
   End
   Begin VB.Label Label10 
      Caption         =   "Output PSF file ="
      Height          =   255
      Left            =   240
      TabIndex        =   25
      Top             =   3360
      Width           =   1215
   End
   Begin VB.Label Label9 
      Caption         =   "Input ASM file ="
      Height          =   255
      Left            =   240
      TabIndex        =   24
      Top             =   3120
      Width           =   1215
   End
   Begin VB.Label Label8 
      Alignment       =   2  'Center
      Caption         =   "CONVERT ASM to PICtutor PSF"
      BeginProperty Font 
         Name            =   "MS Sans Serif"
         Size            =   9.75
         Charset         =   0
         Weight          =   700
         Underline       =   0   'False
         Italic          =   0   'False
         Strikethrough   =   0   'False
      EndProperty
      ForeColor       =   &H00800000&
      Height          =   375
      Left            =   240
      TabIndex        =   23
      Top             =   2160
      Width           =   3615
   End
   Begin VB.Label Label7 
      Alignment       =   2  'Center
      Caption         =   "CONVERT PICtutor PSF to ASM"
      BeginProperty Font 
         Name            =   "MS Sans Serif"
         Size            =   9.75
         Charset         =   0
         Weight          =   700
         Underline       =   0   'False
         Italic          =   0   'False
         Strikethrough   =   0   'False
      EndProperty
      ForeColor       =   &H00800000&
      Height          =   255
      Left            =   360
      TabIndex        =   22
      Top             =   240
      Width           =   3495
   End
   Begin VB.Line Line1 
      BorderColor     =   &H00800000&
      BorderWidth     =   2
      X1              =   240
      X2              =   3960
      Y1              =   2040
      Y2              =   2040
   End
   Begin VB.Label Label6 
      Caption         =   "Output ASM file ="
      Height          =   255
      Left            =   240
      TabIndex        =   15
      Top             =   1440
      Width           =   1335
   End
   Begin VB.Shape Shape2 
      BorderColor     =   &H00C00000&
      BorderWidth     =   2
      Height          =   1695
      Left            =   4200
      Shape           =   4  'Rounded Rectangle
      Top             =   2520
      Width           =   2415
   End
   Begin VB.Label Label5 
      Alignment       =   2  'Center
      Caption         =   "This is a slightly edited version of the original text published in EPE Mar-May 1998."
      ForeColor       =   &H00800000&
      Height          =   615
      Left            =   4320
      TabIndex        =   12
      Top             =   3480
      Width           =   2175
   End
   Begin VB.Label Label4 
      Alignment       =   2  'Center
      Caption         =   "Do NOT edit PICtutor's own PSF files !"
      ForeColor       =   &H00800000&
      Height          =   255
      Left            =   360
      TabIndex        =   9
      Top             =   1725
      Width           =   3495
   End
   Begin VB.Label Label3 
      Caption         =   "Input PSF file ="
      Height          =   255
      Left            =   240
      TabIndex        =   7
      Top             =   1200
      Width           =   1095
   End
   Begin VB.Label Label2 
      Alignment       =   2  'Center
      Caption         =   " PICtutor must already have been installed on your PC. See latest issue of EPE for details of how to purchase it."
      ForeColor       =   &H00800000&
      Height          =   615
      Left            =   4320
      TabIndex        =   5
      Top             =   560
      Width           =   3015
   End
   Begin VB.Label Label1 
      Alignment       =   2  'Center
      Caption         =   "PICtutor (CD ROM edition)"
      BeginProperty Font 
         Name            =   "MS Sans Serif"
         Size            =   9.75
         Charset         =   0
         Weight          =   700
         Underline       =   0   'False
         Italic          =   0   'False
         Strikethrough   =   0   'False
      EndProperty
      ForeColor       =   &H00800000&
      Height          =   255
      Left            =   4440
      TabIndex        =   4
      Top             =   240
      Width           =   2895
   End
   Begin VB.Shape Shape1 
      BorderColor     =   &H00C00000&
      BorderWidth     =   2
      Height          =   4095
      Left            =   120
      Shape           =   4  'Rounded Rectangle
      Top             =   120
      Width           =   3975
   End
End
Attribute VB_Name = "TK3PicTutor"
Attribute VB_GlobalNameSpace = False
Attribute VB_Creatable = False
Attribute VB_PredeclaredId = True
Attribute VB_Exposed = False
' TK3 PIC Tutor etc access 22MAY02

Private Sub ChangePath_Click()
On Error GoTo showerror
FName = "TK3PicTutRoute.txt"
OpenFile = FName
Open FName For Input As #1: Close

OpenFile = EditorName & FName
processid = Shell("Notepad " & FName, vbNormalFocus)
OpenFile = ""
Exit Sub

showerror: Close
TK3ShowError.Show
Call TK3ShowError.waitresponse
Resume enderror
enderror:

End Sub

Private Sub DirASM_Click()
PICpath = 16
FileName = "*.ASM"
TK3Directory.Show
If PICpath <> PrevPICpath Then
 TK3Directory.Dir1.Path = TK3dir(PICpath)
 Call TK3Directory.dirshow
 PrevPICpath = PICpath
 Filepath = inputfile(PICpath)
End If
PSFlistfile = 0

End Sub

Private Sub Errors_Click()
On Error GoTo showerror
If PSFlistfile = 0 Then Call notcreatedyet: Exit Sub
FName = "TK3PSF.ERR"
OpenFile = FName
Open FName For Input As #1: Close

OpenFile = EditorName & FName
processid = Shell(EditorName & FName, vbNormalFocus)
OpenFile = ""
Exit Sub

showerror: Close
TK3ShowError.Show
Call TK3ShowError.waitresponse
Resume enderror
enderror:

End Sub

Private Sub ExtraNotes_Click()

On Error GoTo showerror
FName = "TK3NotesPICTUT.TXT"
Open FName For Input As #1: Close
processid = Shell("Notepad " & FName, vbMaximizedFocus)
Exit Sub

showerror:
Close
TK3ShowError.Show
Call TK3ShowError.waitresponse
Resume enderror
enderror:

End Sub

Private Sub Form_Unload(Cancel As Integer)
Unload TK3PicTutor
End Sub

Private Sub PSFtoASM_Click()
On Error GoTo showerror
Dim psflines(30) As String
Dim psfcode(128, 3) As String
Dim labels(128) As String
Dim equates(128) As String
Dim hexit$(15), statusbit(2)
hexit$(0) = "0000": hexit$(1) = "0001"
hexit$(2) = "0010": hexit$(3) = "0011"
hexit$(4) = "0100": hexit$(5) = "0101"
hexit$(6) = "0110": hexit$(7) = "0111"
hexit$(8) = "1000": hexit$(9) = "1001"
hexit$(10) = "1010": hexit$(11) = "1011"
hexit$(12) = "1100": hexit$(13) = "1101"
hexit$(14) = "1110": hexit$(15) = "1111"
statusbit(0) = ",C": statusbit(1) = ",Z": statusbit(2) = ",DC"

tempf$ = "BTFSS ,BTFSC ,DECF  ,INCF  ,DECFSZ,INCFSZ,MOVF  ,MOVWF ,CLRF  ,"
tempf$ = tempf$ & "ADDWF ,SUBWF ,ANDWF ,COMF  ,IORWF ,RLF   ,RRF   ,SWAPF ,"
tempf$ = tempf$ & "XORWF ,BSF   ,BCF   ,"

If inputfile(15) = "None Yet" Then Call nofileyet: Exit Sub

FileName = inputfile(15)
OpenFile = FileName
Open FileName For Input As #1: L = LOF(1)
tempA$ = Input$(L, 1): Close

' splitfile sections
d = 0: E = 1: For C = 1 To Len(tempA$)
If Asc(Mid$(tempA$, C, 1)) = 182 Then
 psflines(d) = Mid$(tempA$, E, C - E)
 E = C + 1: d = d + 1
End If
Next

' split code
d = 0: E = 1: For C = 1 To Len(psflines(1))
If Mid$(psflines(1), C, 1) = Chr(13) Then
 psfcode(d, 1) = Mid$(psflines(1), E, C - E)
 psfcode(d, 1) = Mid$(psfcode(d, 1), 5) & " "
 psfcode(d, 0) = ""
 psfcode(d, 2) = ""
 psfcode(d, 3) = ""
For F = 1 To Len(psfcode(d, 1))
 If Mid$(psfcode(d, 1), F, 1) = " " Then
 psfcode(d, 2) = Mid$(psfcode(d, 1), F)
 psfcode(d, 2) = RTrim$(LTrim$(psfcode(d, 2)))
 tempB$ = Right$(psfcode(d, 2), 2)
 If Left$(tempB$, 1) = "," Then
   psfcode(d, 3) = Right$(psfcode(d, 2), 2)
   psfcode(d, 2) = Left$(psfcode(d, 2), Len(psfcode(d, 2)) - 2)
   End If
 psfcode(d, 1) = Left$(psfcode(d, 1), F - 1)
  Exit For
  End If
 Next F
 If psfcode(d, 2) <> "" Then psfcode(d, 2) = Val("&H" & psfcode(d, 2))
 E = C + 2: d = d + 1
End If
Next

' split labels
If Len(psflines(2)) > 0 Then
psflines(2) = psflines(2) + Chr(13)
d = 0: E = 1: For C = 1 To Len(psflines(2))
If Mid$(psflines(2), C, 1) = Chr(13) Then
 tempB$ = Mid$(psflines(2), E, C - E)
 If tempB$ <> "" Then
 F = Val("&h" & Right$(tempB$, 3))
 labels(F) = Left$(tempB$, Len(tempB$) - 4)
 psfcode(F, 0) = RTrim$(labels(F))
 End If
  E = C + 2: d = d + 1
End If
Next
End If

labels(5) = "PROG": psfcode(5, 0) = "PROG"

'split equates
psflines(3) = psflines(3) + Chr(13)
d = 0: E = 1: For C = 1 To Len(psflines(3))
If Mid$(psflines(3), C, 1) = Chr(13) Then
 tempB$ = Mid$(psflines(3), E, C - E)
 If Mid$(tempB$, 4) <> "" And Mid$(tempB$, 4, 3) <> "N/A" Then
  F = Val("&h" & Left$(tempB$, 2)): equates(F) = RTrim$(Mid$(tempB$, 4))
 End If
 E = C + 2: d = d + 1
End If
Next

' allocate label jumps
For A = 0 To 127
If psfcode(A, 1) = "GOTO" Then GoSub substitutelabel: GoTo 100
If psfcode(A, 1) = "CALL" Then GoSub substitutelabel: GoTo 100
100
Next

' allocate equates
For A = 0 To 127
If Left$(psfcode(A, 1), 3) <> "NOP" Then
tempB$ = Left$(psfcode(A, 1) & "    ", 6)
 For C = 1 To Len(tempf$) Step 7
  If tempB$ = Mid$(tempf$, C, 6) Then
   GoSub substituteequate: Exit For
  End If
 Next
 End If
Next

FileName = "TK3PicTutRoute.txt"
OpenFile = FileName
Open FileName For Input As #1
Input #1, tempA$: Input #1, tempA$: Close

FileName = tempA$ & NamedOutFile(15)
OpenFile = FileName

Open FileName For Output As #2: OpenFile = ""
Print #2, "; Conversion to ASM from PICtutor PSF file " & Text1.Text & " " & Date$ & " " & Time$
Print #2, ""
Print #2, "; CAUTION - this conversion does not set PORT direction registers"
Print #2, "; and other PAGE1 (BANK1) factors, which must be added as required"
Print #2, ""
Print #2, "; All program values are in decimal."
Print #2, "; The Equates and other Labels are in MPASM format."
Print #2, "; For TASM format add a colon(:) after the labels in column 1,"
Print #2, "; and a decimal point in front of each EQU (i.e.: .EQU)"
Print #2, ""

For A = 0 To 127
If equates(A) <> "" Then Print #2, equates(A) & Chr(9) & "EQU " & A
Next
Print #2, ""

Print #2, "W" & Chr(9) & "EQU 0"
Print #2, "F" & Chr(9) & "EQU 1"
Print #2, "C" & Chr(9) & "EQU 0"
Print #2, "Z" & Chr(9) & "EQU 1"
Print #2, "DC" & Chr(9) & "EQU 2"
Print #2, ""

Print #2, Chr(9) & "ORG 0"
For A = 0 To 127: v = Val(psfcode(A, 2))
If v > 0 And psfcode(A, 1) <> "GOTO" Then
   hexi$ = Right$("0" & Hex$(v), 2)
   tempB$ = Chr(9) & Chr(9) & "; $" & hexi$ & Chr(9) & "h'" & hexi$ & "'"
   B = Val("&h" & Left$(hexi$, 1)): tempB$ = tempB$ & Chr(9) & hexit$(B)
   B = Val("&h" & Right$(hexi$, 1)): tempB$ = tempB$ & hexit$(B)
    If v > 31 Then tempB$ = tempB$ & "   '" & Chr(v) & "'"
   Else: tempB$ = ""
   End If
If psfcode(A, 2) = "STATUS" Then v = Val(psfcode(A, 3)): psfcode(A, 3) = statusbit(v)
   
Print #2, psfcode(A, 0) & Chr(9) & psfcode(A, 1); Chr(9) & psfcode(A, 2) & psfcode(A, 3) & tempB$
Next
Print #2, "": Print #2, Chr(9) & "END"
Close

beep
tempB$ = "Conversion of " & Text1.Text & " completed"
tempB$ = tempB$ & Chr(13) & "The new file is held in directory (folder) " & Chr(13) & Chr(13) & UCase$(FileName)
tempB$ = tempB$ & Chr(13) & Chr(13) & "Would you like to view it now?"

Style = vbYesNo + vbExclamation
response = MsgBox(tempB$, Style)
If response = vbNo Then
  Exit Sub
  Else
OpenFile = EditorName & FileName
processid = Shell(EditorName & FileName, vbMaximizedFocus)
OpenFile = ""
End If

Exit Sub

substitutelabel:
v = Val(psfcode(A, 2))
 If labels(v) <> "" Then
  psfcode(A, 2) = labels(v)
  Else
  psfcode(v, 0) = psfcode(A, 2)
  End If
Return

substituteequate:
v = Val(psfcode(A, 2)): psfcode(A, 2) = equates(v)
Return

showerror:
TK3ShowError.Show
Call TK3ShowError.waitresponse
Resume enderror
enderror:

End Sub

Private Sub DirPSF_Click()
PICpath = 15
FileName = "*.PSF"
TK3Directory.Show
If PICpath <> PrevPICpath Then
 TK3Directory.Dir1.Path = TK3dir(PICpath)
 Call TK3Directory.dirshow
 PrevPICpath = PICpath
 Filepath = inputfile(PICpath)
End If

End Sub

Private Sub PICtutor_Click()
On Error GoTo showerror
FileName = "TK3PicTutRoute.txt"
OpenFile = FileName
Open FileName For Input As #1
Input #1, tempA$: Close
FileName = tempA$
OpenFile = FileName
processid = Shell(FileName, vbMaximizedFocus)
OpenFile = ""
Exit Sub

showerror: Close
TK3ShowError.Show
Call TK3ShowError.waitresponse
Resume enderror
enderror:

End Sub

Private Sub PICTuttext_Click()
On Error GoTo showerror
FName = "TK3PICtutor.txt"
Open FName For Input As #1: Close
processid = Shell("Notepad " & FName, vbMaximizedFocus)
Exit Sub

showerror:
Close
TK3ShowError.Show
Call TK3ShowError.waitresponse
Resume enderror
enderror:

End Sub

Private Sub Quit_Click()
Unload TK3PicTutor
End Sub

Private Sub Text1_dblclick()
beep
DirPSF.SetFocus
If inputfile(15) = "None Yet" Then Call nofileyet: Exit Sub
MsgBox "Full path name = " & Chr(13) & Chr(13) & inputfile(15), vbInformation
End Sub

Private Sub Text2_dblclick()
beep
DirPSF.SetFocus
If inputfile(15) = "None Yet" Then Call nofileyet: Exit Sub
MsgBox "Full path name = " & Chr(13) & Chr(13) & outputfile(15), vbInformation
End Sub

Private Sub text3_dblclick()
beep
DirASM.SetFocus
If inputfile(16) = "None Yet" Then Call nofileyet: Exit Sub
MsgBox "Full path name = " & Chr(13) & Chr(13) & inputfile(16), vbInformation
End Sub

Private Sub text4_dblclick()
beep
DirASM.SetFocus
If inputfile(16) = "None Yet" Then Call nofileyet: Exit Sub
MsgBox "Full path name = " & Chr(13) & Chr(13) & outputfile(16), vbInformation
End Sub

Private Sub ViewASMPSF_Click()
If errorcount > 0 Then Call notcreatedyet: Exit Sub
FileName = outputfile(16): Call Showfile
End Sub

Private Sub ViewOrigPSF_Click()
FileName = inputfile(15): Call Showfile
End Sub

Private Sub ViewOrigASM_Click()
FileName = inputfile(16): Call Showfile
End Sub

Private Sub ASMtoPSF_Click()
On Error GoTo showerror
If inputfile(16) = "None Yet" Then Call nofileyet: Exit Sub
FileName = inputfile(16)
PSFlistfile = 1

Dim PICcode$(255), CODE%(255), ba$(10): ' DA$(100)
Dim PICequate$(500), equate%(500), define$(200), PIClabel$(2000), label%(2000)
Dim mainline%(16383, 2), jump%(2000), PICjump$(2000), expand$(50)
Dim psf$(4)
Dim finalpsf$(200, 4)
Dim temp$(&H2F)

Dim hexit$(15)
hexit$(0) = "0000": hexit$(1) = "0001"
hexit$(2) = "0010": hexit$(3) = "0011"
hexit$(4) = "0100": hexit$(5) = "0101"
hexit$(6) = "0110": hexit$(7) = "0111"
hexit$(8) = "1000": hexit$(9) = "1001"
hexit$(10) = "1010": hexit$(11) = "1011"
hexit$(12) = "1100": hexit$(13) = "1101"
hexit$(14) = "1110": hexit$(15) = "1111"

radix$ = "R=DEC": org% = 0
FileName = inputfile(16)

L = Len(FileName):
filebase$ = Left$(FileName, L - 4)

For C = Len(filebase$) To 1 Step -1
 If Mid$(filebase, C, 1) = "\" Then
   pathbase$ = Left$(filebase$, C): Exit For
   End If
Next

y$ = Chr(13) & Chr(10)

errorcount = 0: F = 0
mainlinea% = 0
spx$ = "                                                  "
orgflag% = 0: jumpx% = 0

OpenFile = "TK3asmcodes.TXT"
Open "TK3asmcodes.TXT" For Input As #1: CodeCount = 0
OpenFile = ""
getcodes: If EOF(1) Then Close 1: GoTo sortcodes
Line Input #1, tempA$
CodeCount = CodeCount + 1: PICcode$(CodeCount) = tempA$
GoTo getcodes

sortcodes: num% = CodeCount: Span% = num% / 2
Do While Span% > 0: For I% = Span% To num% - 1: j% = I% - Span% + 1
For j% = (I% - Span% + 1) To 1 Step -Span%
If PICcode$(j%) <= PICcode$(j% + Span%) Then Exit For
tempA$ = PICcode$(j%): PICcode$(j%) = PICcode$(j% + Span%): ' = tempA$
PICcode$(j% + Span%) = tempA$
Next j%: Next I%: Span% = Span% / 2: Loop

For A = 1 To CodeCount: h$ = PICcode$(A):
If Right$(h$, 1) = "*" Then h$ = Left$(h$, Len(h$) - 2)
GoSub getbin: CODE%(A) = v%: Next

getsource:

OpenFile = FileName
Open FileName For Input As #1: L = LOF(1) + 2
OpenFile = ""

Open "TK3PSF.ERR" For Output As #5: ' error details file

Print #5, "ERRORS LIST " & FileName & " " & Date$ & " " & Time$: Print #5, ""
Print #5, "List created during conversion to PIC Tutor PSF file": Print #5, ""

getit1: If EOF(1) Then GoTo noorg

getit1a:
Line Input #1, tempB$: tempstore$ = tempB$: jx$ = tempB$

mainlinea% = mainlinea% + 1
tempB$ = UCase$(RTrim$(tempB$))
If Left$(tempB$, 1) = ";" Then GoTo getit1
PICreg$ = ""

ba$(0) = "": tempC$ = ""
d = 0: E = 1: For C = 1 To Len(tempB$): tempA$ = Mid$(tempB$, C, 1)
If tempA$ = ";" Then ba$(1) = " " + Mid$(tempB$, C): Exit For
If tempA$ = Chr$(9) Then tempA$ = " "
If tempA$ = " " And tempC$ = " " Then GoTo getit2b: 'avoid double spaces
If tempA$ = " " And tempC$ = "," Then GoTo getit2b: 'avoid space after command comma
If tempA$ = ":" Then ba$(0) = ba$(0) + tempA$: tempA$ = " ": 'correct for no space after label colon
ba$(0) = ba$(0) + tempA$
getit2b: tempC$ = tempA$: Next
tempB$ = ba$(0)

If Left$(LTrim$(tempB$), 4) = "LIST" Then
 For dx = 1 To Len(tempB$):  ' check for RADIX
 If Mid$(tempB$, dx, 2) = "R=" Then radix$ = Mid$(tempB$, dx): Exit For
 Next:
End If

If Left$(tempB$, 7) = "#DEFINE" Then GoSub getdefine: GoTo getit1

GoSub splitit1:
If DA$(2) = "#DEFINE" Then tempB$ = LTrim$(tempB$): GoSub getdefine: GoTo getit1

If DA$(2) = "EQU" Or DA$(2) = "SET" Then GoSub getequate: GoTo getit1
If DA$(1) = "ORG" Then DA$(3) = DA$(2): DA$(2) = DA$(1): DA$(1) = ""

If DA$(2) <> "ORG" Then GoTo getit1
GoSub getorigin

If org% <> 0 And org% <> 4 And org% <> 5 Then
beep
listk$ = "An ORG value of " & DA$(3) & " has been found."
tempA$ = listk$: Print #5, listk$
listk$ = "Only ORG 0, ORG 4 and ORG 5 are allowed by PICtutor"
tempA$ = tempA$ & Chr(13) & listk$
Print #5, listk$: Close
  MsgBox tempA$, vbCritical
  Close:  Exit Sub
  End If

address% = org%:

If org% = 0 Then address% = -1
mainline%(mainlinea% + 1, 0) = address%

GoSub sortequates: ba$(0) = "": ba$(1) = ""

getit2: If EOF(1) Then GoTo 2100
Line Input #1, tempB$: jx$ = tempB$

tempB$ = UCase$(tempB$)

ba$(0) = "": ba$(1) = "": tempC$ = ""
d = 0: E = 1: For C = 1 To Len(tempB$): tempA$ = Mid$(tempB$, C, 1)
If tempA$ = ";" Then ba$(1) = " " + Mid$(tempB$, C): Exit For
If tempA$ = Chr$(9) Then tempA$ = " "
If tempA$ = " " And tempC$ = " " Then GoTo getit2x: 'avoid double spaces
If tempA$ = " " And tempC$ = "," Then GoTo getit2x: 'avoid space after command comma
If tempA$ = ":" Then ba$(0) = ba$(0) + tempA$: tempA$ = " ": 'correct for no space after label colon
ba$(0) = ba$(0) + tempA$
getit2x: tempC$ = tempA$: Next

mainlinea% = mainlinea% + 1
tempB$ = ba$(0): If Left$(tempB$, 1) = " " Then tempB$ = ".       " + tempB$
tempx$ = tempB$

ba$(0) = RTrim$(ba$(0)): PICreg$ = ""
If ba$(0) = "" Then GoTo 2010
GoSub splitit:

If DA$(1) = "ORG" Then DA$(3) = DA$(2): DA$(2) = DA$(1): DA$(1) = ""
If DA$(2) = "ORG" Then
   GoSub getorigin
   If org% > 5 Then
   beep
   listk$ = "An ORG value of " & DA$(3) & " has been found."
tempA$ = listk$
listk$ = "Only ORGs 0, 4 and 5 are allowed by the PICtutor conversion."
tempA$ = tempA$ & Chr(13) & listk$
   Print #5, listk$: Close
   MsgBox tempA$, vbCritical
     Close
  Exit Sub
  End If
  GoTo 2010
End If
   
If DA$(2) = "END" Then GoTo 2010
If (DA$(2) = "CLRF" Or DA$(2) = "MOVWF") And DA$(4) <> "" Then
  errorcount = errorcount + 1
  listk$ = DA$(2) & Chr(9) & "unexpected " & DA$(4) & " suffix used at line " & mainlinea%
  mainline%(mainlinea%, 2) = 1
  Print #5, listk$
End If

If DA$(1) <> "" Then GoSub getlabel
If DA$(2) = "" Then GoTo 2010
address% = address% + 1

If orgflag% > 0 Then
  address% = org%:
  orgflag% = 0
  End If

If labelflag% > 0 Then GoSub setlabel

GoSub compileit

If PICreg$ <> "" Then jp% = jp% + 1: jump%(jp%) = mainlinea%: PICjump$(jp%) = PICreg$
mainline%(mainlinea%, 0) = address%: mainline%(mainlinea%, 1) = PICbyte
If address% > 127 Then
beep
listk$ = "This code has exceeded the maximum 127 allowable PICtutor commands."
tempA$ = listk$: Print #5, listk$
listk$ = "Conversion has been terminated. The command last received is ": ' & Chr(13)
tempA$ = tempA$ & Chr(13) & listk$: Print #5, listk$
Print #5, "": Print #5, jx$: Print #5, "":
tempA$ = tempA$ & Chr(13) & Chr(13) & jx$
If errorcount > 1 Then
 listk$ = errorcount & " other errors have also been found"
tempA$ = tempA$ + Chr(13) & Chr(13) & listk$
End If
  MsgBox tempA$, vbCritical
  Close
  Exit Sub
  End If

psf$(0) = Right$("00" & Hex$(address%), 3)
If psf$(3) <> "" Then psf$(3) = "," & psf$(3)
If psf$(1) = "RETURN" Then psf$(2) = ""
finalpsf$(address%, 0) = psf$(0)
finalpsf$(address%, 1) = psf$(1)
finalpsf$(address%, 2) = psf$(2)
finalpsf$(address%, 3) = psf$(3)
finalpsf$(address%, 4) = psf$(4)
psf$(0) = "": psf$(1) = "": psf$(2) = "": psf$(3) = "": psf$(4) = ""

2010: GoTo getit2

2100: Close 1: Close 2: GoSub sort

doaddresses:
For A = 1 To jp%: B% = jump%(A): k$ = PICjump$(A): GoSub labelchop
v% = label%(Q): w% = mainline%(B%, 1): x% = v% Or w%: mainline%(B%, 1) = x%
C = mainline%(B%, 0)
finalpsf$(C, 2) = Right$("00" & Hex$(v%), 3)
Next

If errorcount > 0 Then
  Close
  beep
  MsgBox errorcount & " errors found. Conversion aborted.", vbCritical
  Exit Sub
  Else: Print #5, "": Print #5, "No Errors"
  End If

For A = 1 To eq%: v = equate%(A)
If v = 1 Or v = 7 Or v = 8 Or v = 9 Or v = 10 Or v = 11 Then
  If PICequate$(A) = "F " Then GoTo eqOK
  If PICequate$(A) = "W " Then GoTo eqOK
  If PICequate$(A) = "C " Then GoTo eqOK
  If PICequate$(A) = "Z " Then GoTo eqOK
  If PICequate$(A) = "DC " Then GoTo eqOK
  beep
listk$ = "PICtutor does not recognise " & PICequate$(A)
tempA$ = listk$: Print #5, listk$: Close
tempA$ = tempA$ & "Please amend your program." & Chr(13) & "Conversion aborted."

MsgBox tempA$, vbCritical
  Exit Sub
  End If
temp$(v) = PICequate$(A)
eqOK: Next

FileName = "TK3PicTutRoute.txt"
OpenFile = FileName
Open FileName For Input As #1
Input #1, tempA$: Input #1, tempA$: Input #1, tempA$: Close

FileName = tempA$
OpenFile = FileName
Open FileName For Input As #1
Input #1, tempA$: Close

For C = 1 To Len(tempA$)
 If Mid$(tempA$, C, 1) = Chr(182) Then
   tempA$ = Left$(tempA$, C - 1): Exit For
   End If
Next

Open outputfile(16) For Output As #2
Print #2, tempA$; Chr(182);

If finalpsf$(0, 0) = "" Then
 finalpsf$(0, 0) = "000"
 finalpsf$(0, 1) = "GOTO"
 finalpsf$(0, 2) = "005"
 finalpsf$(4, 0) = "004"
 finalpsf$(4, 1) = "GOTO"
 finalpsf$(4, 2) = "005"
End If

For A% = 0 To 127: B% = mainline%(A%, 0)
If finalpsf$(A%, 0) = "" Then
finalpsf$(A%, 0) = Right$("00" & Hex$(A%), 3)
finalpsf$(A%, 1) = "NOP"
End If

If finalpsf$(A%, 1) <> "" Then finalpsf$(A%, 1) = " " & finalpsf$(A%, 1)
If finalpsf$(A%, 2) <> "" Then finalpsf$(A%, 2) = " " & finalpsf$(A%, 2)

Print #2, finalpsf$(A%, 0); finalpsf$(A%, 1); finalpsf$(A%, 2); finalpsf$(A%, 3);
If A% <> 127 Then Print #2, ""
Next: Print #2, Chr(182);

For A = 1 To alabel%
h$ = Right$("000" + Hex$(label%(A)), 3)
Print #2, Left$(PIClabel$(A) & "        ", 9); h$;
If A <> alabel% Then Print #2, ""
Next: Print #2, Chr(182);

Print #2, "00 INDF"
Print #2, "01 N/A"
Print #2, "02 PCL"
Print #2, "03 STATUS"
Print #2, "04 FSR"
Print #2, "05 PORTA"
Print #2, "06 PORTB"
Print #2, "07 N/A"
Print #2, "08 N/A"
Print #2, "09 N/A"
Print #2, "0A N/A"
Print #2, "0B N/A"

For A = &HC To &H2F
h$ = Right$("00" + Hex$(A), 2) & " "
Print #2, h$;: If temp$(A) <> "" Then Print #2, Left$(temp$(A) & "       ", 7);
If A <> &H2F Then Print #2, ""
Next: Print #2, Chr(182);

Print #2, "00 INDF   00"
Print #2, "01 N/A    00"
Print #2, "02 PCL    00"
Print #2, "03 STATUS 00"
Print #2, "04 FSR    00"
Print #2, "05 PORTA  00"
Print #2, "06 PORTB  00"
Print #2, "07 N/A    00"
Print #2, "08 N/A    00"
Print #2, "09 N/A    00"
Print #2, "0A N/A    00"
Print #2, "0B N/A    00"

For A = &HC To &H2F
h$ = Right$("00" + Hex$(A), 2) & " "
Print #2, h$; Left$(temp$(A) & "        ", 7); "00";
If A <> &H2F Then Print #2, ""
Next: Print #2, Chr(182);

Print #2, "00 INDF"
Print #2, "01 N/A"
Print #2, "02 PCL"
Print #2, "03 STATUS"
Print #2, "04 FSR"
Print #2, "05 PORTA"
Print #2, "06 PORTB"
Print #2, "07 N/A"
Print #2, "08 N/A"
Print #2, "09 N/A"
Print #2, "0A N/A"
Print #2, "0B N/A"

For A = &HC To &H2F
h$ = Right$("00" + Hex$(A), 2) & " "
Print #2, h$;: If temp$(A) <> "" Then Print #2, Left$(temp$(A) & "       ", 7);
If A <> &H2F Then Print #2, ""
Next: Print #2, Chr(182);

Print #2, "000"; Chr(182); "GOTO 005"; Chr(182);
For A = 1 To 8: Print #2, "00"; Chr(182);: Next
For A = 1 To 8: Print #2, "000"; Chr(182);: Next
Print #2, "0"; Chr(182)

finalbit:

endgeterr:

Close:
MsgBox "Finished Conversion to " & outputfile(16), vbInformation
Exit Sub

'*****************

convertvalue: v% = 0: h$ = DA$(3)
If Left$(h$, 1) = "$" Then h$ = Mid$(h$, 2): GoSub gethex: h$ = "": Return
If Left$(h$, 1) = "%" Then h$ = Mid$(h$, 2): GoSub getbin: h$ = "": Return
If h$ = "0" Then v% = 0: Return
If Left$(h$, 2) = "0X" Then h$ = Mid$(h$, 3): GoSub gethex: h$ = "": Return
If Left$(h$, 2) = "OX" Then h$ = Mid$(h$, 3): GoSub gethex: h$ = "": Return
If Left$(h$, 1) = "0" Then GoSub gethex: h$ = "": Return
If Left$(h$, 2) = "B'" Then h$ = Mid$(h$, 3, 8): GoSub getbin: h$ = "": Return
If Left$(h$, 2) = "D'" Then v% = Val(Mid$(h$, 3)): h$ = "": Return
If Left$(h$, 2) = "H'" Then h$ = Mid$(h$, 3): GoSub gethex: h$ = "": Return
v% = Val(h$): If v% > 0 And radix$ = "R=HEX" Then GoSub gethex: h$ = "":
Return

'..............

getequate:
If Right$(DA$(1), 1) = ":" Then L = Len(DA$(1)): DA$(1) = Left$(DA$(1), L - 1)
GoSub convertvalue

If h$ <> "" Then
 If Left$(h$, 1) < "0" Or Left$(h$, 1) > "9" Then
  errorcount = errorcount + 1: v% = 0
  listk$ = h$ & Chr(9) & "invalid equate value at line " & mainlinea%
  mainline%(mainlinea%, 2) = 1
  Print #5, listk$
 End If
End If
geteq1: eq% = eq% + 1: PICequate$(eq%) = DA$(1) + " ": equate%(eq%) = v%:
If v% > &H2F Then

beep
listk$ = "An equates value greater than allowable by PICtutor has been found."
tempA$ = listk$: Print #5, listk$
listk$ = "The conversion has been terminated. The code line last received is"
tempA$ = tempA$ & Chr(13) & listk$: Print #5, listk$
Print #5, "": Print #5, jx$: Close
tempA$ = tempA$ & Chr(13) & Chr(13) & jx$
MsgBox tempA$, vbCritical
Exit Sub
End If
Return

getorigin: GoSub convertvalue: orgflag% = orgflag% + 1: org% = v%: Return

getlabel: alabel% = alabel% + 1: L = Len(DA$(1)): labelflag% = labelflag% + 1
If Right$(DA$(1), 1) = ":" Then L = L - 1
PIClabel$(alabel%) = Left$(DA$(1), L) + " ": Return

setlabel: label%(alabel%) = address%: If labelflag% > 2 Then labelflag = 2
If labelflag% = 2 Then label%(alabel% - 1) = address%
labelflag% = 0: Return

gethex:
If Left$(h$, 1) >= "0" And Left$(h$, 1) <= "9" Then v% = Val("&H" + h$): Return
If Left$(h$, 1) >= "A" And Left$(h$, 1) <= "F" Then v% = Val("&H" + h$): Return
  errorcount = errorcount + 1: v% = 0
  listk$ = h$ & Chr(9) & "invalid hex value at line " & mainlinea%
  mainline%(mainlinea%, 2) = 1
  Print #5, listk$: Return

getbin:
L = Len(h$): If Right$(h$, 1) = "%" Then L = L - 1: h$ = Left$(h$, L)
d = 0: v% = 0: For C = L To 1 Step -1: E = Val(Mid$(h$, C, 1)) * (2 ^ d)
v% = v% + E: d = d + 1: Next: Return

getasc:
For C = 1 To Len(jx$)
If Mid$(jx$, C, 1) = "'" Then v% = Asc(Mid$(jx$, C + 1, 1)): Exit For
Next
Return

getdefine: adefine% = adefine% + 1: h$ = Mid$(tempB$, 9)
define$(adefine%) = RTrim$(LTrim$(h$))
tempB$ = h$: GoSub splitit1: DA$(3) = DA$(2)
GoSub convertvalue: If h$ >= "A" Then Return
eq% = eq% + 1: PICequate$(eq%) = DA$(1) + " ": equate%(eq%) = v%
Return

splitit1: tempB$ = tempB$ + " ": d = 0: E = 1: For C = 1 To Len(tempB$)
If Mid$(tempB$, C, 1) <> " " Then GoTo bypass1
If Mid$(tempB$, C, 2) = "  " Then GoTo bypass1
If d > 4 Then Exit For
d = d + 1: DA$(d) = RTrim$(Mid$(tempB$, E, C - E)): E = C + 1
bypass1: Next: For C = d + 1 To 5: DA$(C) = "": Next:
If Left$(DA$(2), 1) = "." Then DA$(2) = Mid$(DA$(2), 2): '***
Return

splitit: tempC$ = ba$(0) + " "
For C = 1 To 4: DA$(C) = "": Next
d = 0: E = 1: For C = 1 To Len(tempC$)
If Mid$(tempC$, C, 1) <> "'" Then GoTo split3
If Mid$(tempC$, C, 3) = "' '" Then C = C + 2: GoTo bypass
If Mid$(tempC$, C + 2, 2) <> " '" Then GoTo split3
tempC$ = Left$(tempC$, C + 1) + Mid$(tempC$, C + 3) + " ": GoTo bypass
If Mid$(tempC$, C, 4) = "': '" Then C = C + 3: GoTo bypass
split3:
If Mid$(tempC$, C, 1) <> " " And Mid$(tempC$, C, 1) <> "," Then GoTo bypass
If Mid$(tempC$, C, 2) = "  " Then GoTo bypass
If d > 4 Then Exit For
d = d + 1: DA$(d) = Mid$(tempC$, E, C - E): E = C + 1
bypass: Next:
If Left$(DA$(2), 1) = "." Then DA$(2) = Mid$(DA$(2), 2): '***
Return

compileit: k$ = DA$(2) + " ": GoSub PICcodechop: QX = Q
If Q = 0 Then
   GoSub substitute:
   If expander > 0 Then Return
   If v% > 0 Then GoTo compileit
End If
psf$(1) = DA$(2): psf$(2) = DA$(3)
If Left$(DA$(3), 1) = "$" Then psf$(2) = Mid$(psf$(2), 2)
If Q < 1 Then psf$(1) = psf$(1) & "Not found"
PICbyte = CODE%(Q): If Q = 0 Then Number = 1000
GoSub convertvalue:
If Left$(h$, 1) = "'" Then GoSub getasc: GoTo comp1
If h$ >= "A" Then GoSub getreg

comp1: PICbyte = PICbyte Or v%
If DA$(4) = "F" Or DA$(4) = "W" Then psf$(3) = DA$(4): Return
If DA$(4) <> "" Then GoSub getdest: PICbyte = PICbyte Or (v% * 128): psf$(3) = v%: Return
If Right$(PICcode$(QX), 1) <> "*" Then psf$(2) = Right$("0" & Hex$(v%), 2): Return
If DA$(4) <> "" Then Return

v% = 0: L = Len(DA$(3)): For Q = 1 To adefine%
If DA$(3) = Left$(define$(Q), L) Then v% = Q: Exit For
Next:

If v% > 0 Then
ba$(0) = " " & DA$(2) & " " & LTrim$(Mid$(define$(v%), L + 1)):
DA$(4) = ""
GoSub splitit: If DA$(4) = "" Then GoTo destinationerror
GoSub getdest: PICbyte = PICbyte Or (v% * 128): psf$(3) = v%:
mainlinea% = mainlinea% + 1
Return
End If

destinationerror:
errorcount = errorcount + 1
listk$ = k$ & Chr(9) & "destination (W/F or bit) missing at line " & mainlinea%
mainline%(mainlinea%, 2) = 1
Print #5, listk$
Return

getdest: k$ = DA$(4) + " ":
If Left$(k$, 1) = "$" Then v% = Val("&H" + Mid$(k$, 2)): Return
If Val(k$) > 0 Or k$ = "0 " Then v% = Val(k$): Return
GoSub binarychop3: v% = equate%(Q)

If Q > 0 Then Return

errorcount = errorcount + 1:
listk$ = k$ & Chr(9) & "equate unknown at line " & mainlinea%
mainline%(mainlinea%, 2) = 1
Print #5, listk$: Return

getreg: fa% = 0: v% = 0: k$ = DA$(3) + " "
GoSub binarychop3: v% = equate%(Q): If Q = 0 Then PICreg$ = k$:
psf$(2) = Right$("0" & Hex$(v%), 2)
If Q <> 0 Then Return
 
PICcodechop:
L = 1: h = CodeCount: kl = Len(k$)
chop1: Q = Int((h + L) / 2): If Left$(PICcode$(Q), kl) = k$ Then Return
If k$ < PICcode$(Q) Or PICcode$(Q) = "" Then h = Q - 1 Else L = Q + 1
If L > h Then Q = 0: Return
GoTo chop1

labelchop:
L = 1: h = alabel%: kl = Len(k$)
chop21: Q = Int((h + L) / 2):
If Left$(PIClabel$(Q), kl) = k$ Then Return
If k$ < PIClabel$(Q) Or PIClabel$(Q) = "" Then h = Q - 1 Else L = Q + 1
If L > h Then Q = 0 Else GoTo chop21
errorcount = errorcount + 1
listk$ = Left$(k$ + "            ", 10) & "label/equate unknown at line " & B%
mainline%(B%, 2) = 1
Print #5, listk$
Return

binarychop3: L = 1: h = eq%: kl = Len(k$)
chop31: Q = Int((h + L) / 2): If Left$(PICequate$(Q), kl) = k$ Then Return
If k$ < PICequate$(Q) Or PICequate$(Q) = "" Then h = Q - 1 Else L = Q + 1
If L > h Then Q = 0: Return
GoTo chop31

substitute: v% = 0: L = Len(DA$(2)): For Q = 1 To adefine%
If DA$(2) = Left$(define$(Q), L) Then v% = Q: Exit For
Next:
If v% = 0 Then GoTo checkexpand
ba$(0) = define$(v%): GoSub splitit:
mainlinea% = mainlinea% + 1
Return

checkexpand:
errorcount = errorcount + 1
listk$ = DA$(2) & Chr(9) & "command unfound at line " & mainlinea%
mainline%(mainlinea%, 2) = 1
Print #5, listk$
Return

'***************

sort: num% = alabel%: Span% = num% / 2
Do While Span% > 0: For I% = Span% To num% - 1: j% = I% - Span% + 1
For j% = (I% - Span% + 1) To 1 Step -Span%
If PIClabel$(j%) <= PIClabel$(j% + Span%) Then Exit For
tempA$ = PIClabel$(j%): PIClabel$(j%) = PIClabel$(j% + Span%): PIClabel$(j% + Span%) = tempA$
A = label%(j%): label%(j%) = label%(j% + Span%): label%(j% + Span%) = A
Next j%: Next I%: Span% = Span% / 2: Loop:

checkrepeatlabels:
For A = 1 To alabel%:
If PIClabel$(A) = PIClabel$(A + 1) Then
  errorcount = errorcount + 1
  listk$ = PIClabel$(A) & Chr(9) & " duplicate labels at Prog Counts "
  listk$ = listk$ & Right$("000" & Hex$(label%(A)), 4) & " & " & Right$("000" & Hex$(label%(A + 1)), 4)
  Print #5, listk$
End If
Next: Return

sortequates:
num% = eq%: Span% = num% / 2
Do While Span% > 0: For I% = Span% To num% - 1: j% = I% - Span% + 1
For j% = (I% - Span% + 1) To 1 Step -Span%
If PICequate$(j%) <= PICequate$(j% + Span%) Then Exit For
tempA$ = PICequate$(j%): PICequate$(j%) = PICequate$(j% + Span%): PICequate$(j% + Span%) = tempA$
A = equate%(j%): equate%(j%) = equate%(j% + Span%): equate%(j% + Span%) = A
Next j%: Next I%: Span% = Span% / 2: Loop

checkrepeatequates:
For A = 1 To eq%:
If PICequate$(A) <> PICequate$(A + 1) Then GoTo cre2
If equate%(A) = equate%(A + 1) Then GoTo cre2
errorcount = errorcount + 1:
listk$ = PICequate$(A) & Chr(9) & " H" & Hex$(equate%(A)) & " duplicate equates"
mainline%(equate%(A), 2) = 1
mainline%(equate%(A + 1), 2) = 1
  Print #5, listk$
listk$ = PICequate$(A + 1) & Chr(9) & " H" & Hex$(equate%(A + 1)) & " duplicate equates"
Print #5, listk$
cre2: Next

sortdefines:
num% = adefine%: Span% = num% / 2
Do While Span% > 0: For I% = Span% To num% - 1: j% = I% - Span% + 1
For j% = (I% - Span% + 1) To 1 Step -Span%
If define$(j%) <= define$(j% + Span%) Then Exit For
tempA$ = define$(j%): define$(j%) = define$(j% + Span%): define$(j% + Span%) = tempA$
Next j%: Next I%: Span% = Span% / 2: Loop

checkrepeatdefines:
For A = 1 To adefine%
If define$(A) <> define$(A + 1) Then GoTo cre3
errorcount = errorcount + 1:
listk$ = define$(A) & Chr(9) & " duplicate definition"
Print #5, listk$
listk$ = define$(A + 1) & Chr(9) & " duplicate definition"
Print #5, listk$
cre3: Next: Return

'****************

noorg:
errorcount = errorcount + 1
listk$ = "Assembly not made as no ORG value found in ASM file."
Print #5, listk$: tempA$ = listk$ & Chr(13) & Chr(13)
Print #5, ""
listk$ = "An ORG statement (e.g. 0RG 0 or ORG 5) must follow "
Print #5, listk$: tempA$ = tempA$ & listk$
listk$ = "the end of Equates and Definitions etc, and must then precede the "
Print #5, listk$: tempA$ = tempA$ & listk$
listk$ = "first program command statement. "
Print #5, listk$: tempA$ = tempA$ & listk$ & Chr(13) & Chr(13)
Print #5, ""
Print #5, "Please re-read the PICtutor text!"
Print #5, "": Close
beep
MsgBox tempA$, vbCritical
Exit Sub
'....................

showerror:
Close
TK3ShowError.Show
Call TK3ShowError.waitresponse
Resume enderror
enderror:
Exit Sub

End Sub

Private Sub ViewPSFASM_Click()
FileName = outputfile(15): Call Showfile
End Sub
Private Sub Showfile()
On Error GoTo showerror
If FileName = "None Yet" Then Call nofileyet: Exit Sub
 
OpenFile = FileName
Open FileName For Input As #1: Close: 'file error intercept

OpenFile = EditorName & FileName
processid = Shell(EditorName & FileName, vbNormalFocus)
OpenFile = ""

Exit Sub

showerror:
If err.Number = 53 Then
Call notcreatedyet
Resume enderror
End If

TK3ShowError.Show
Call TK3ShowError.waitresponse
Resume enderror
enderror:
Close

End Sub

Private Sub nofileyet()
beep
MsgBox "No file has been selected yet", vbExclamation
End Sub

Private Sub notcreatedyet()
beep
MsgBox "File has not been created yet", vbExclamation
End Sub

